/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ChapitreDto;
import com.moscepa.dto.ElementConstitutifRequestDto;
import com.moscepa.dto.ElementConstitutifResponseDto;
import com.moscepa.dto.EnseignantDto;
import com.moscepa.dto.SectionDto;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.UniteEnseignement;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.UniteEnseignementRepository;
import com.moscepa.repository.UtilisateurRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElementConstitutifService {
    @Autowired
    private ElementConstitutifRepository elementRepository;
    @Autowired
    private UniteEnseignementRepository ueRepository;
    @Autowired
    private UtilisateurRepository utilisateurRepository;

    @Transactional(readOnly=true)
    public List<ElementConstitutifResponseDto> findMatieresByEtudiantId(Long etudiantId) {
        System.out.println("\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.out.println("!!! [SERVICE] \u00c9TAPE 1: Entr\u00e9e dans findMatieresByEtudiantId pour l'\u00e9tudiant ID: " + etudiantId);
        List matieres = this.elementRepository.findMatieresByEtudiantIdSqlNatif(etudiantId);
        System.out.println("!!! [SERVICE] \u00c9TAPE 2: La requ\u00eate SQL native a retourn\u00e9 " + matieres.size() + " mati\u00e8re(s).");
        if (!matieres.isEmpty()) {
            System.out.println("!!! [SERVICE] Mati\u00e8res trouv\u00e9es: " + matieres.stream().map(ElementConstitutif::getNom).collect(Collectors.joining(", ")));
        }
        List<ElementConstitutifResponseDto> dtos = matieres.stream().map(arg_0 -> this.convertToResponseDto(arg_0)).collect(Collectors.toList());
        System.out.println("!!! [SERVICE] \u00c9TAPE 3: Conversion en DTO termin\u00e9e. Renvoi de " + dtos.size() + " DTO(s).");
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
        return dtos;
    }

    @Transactional
    public ElementConstitutifResponseDto create(Long ueId, ElementConstitutifRequestDto dto) {
        UniteEnseignement ue = (UniteEnseignement)this.ueRepository.findById((Object)ueId).orElseThrow(() -> new EntityNotFoundException("Unit\u00e9 d'Enseignement non trouv\u00e9e avec l'ID: " + ueId));
        Utilisateur enseignant = null;
        if (dto.getEnseignantId() != null) {
            enseignant = (Utilisateur)this.utilisateurRepository.findById((Object)dto.getEnseignantId()).orElseThrow(() -> new EntityNotFoundException("Enseignant non trouv\u00e9 avec l'ID: " + dto.getEnseignantId()));
        }
        ElementConstitutif nouvelElement = new ElementConstitutif();
        nouvelElement.setNom(dto.getNom());
        nouvelElement.setCode(dto.getCode());
        nouvelElement.setDescription(dto.getDescription());
        nouvelElement.setCredit(dto.getCredit());
        nouvelElement.setUniteEnseignement(ue);
        nouvelElement.setEnseignant(enseignant);
        nouvelElement.setVolumeHoraireCours(dto.getVolumeHoraireCours());
        nouvelElement.setVolumeHoraireTD(dto.getVolumeHoraireTD());
        nouvelElement.setVolumeHoraireTP(dto.getVolumeHoraireTP());
        ElementConstitutif savedElement = (ElementConstitutif)this.elementRepository.save((Object)nouvelElement);
        return this.convertToResponseDto(savedElement);
    }

    @Transactional(readOnly=true)
    public List<ElementConstitutifResponseDto> findByUeId(Long ueId) {
        return this.elementRepository.findByUniteEnseignementId(ueId).stream().map(arg_0 -> this.convertToResponseDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<ElementConstitutifResponseDto> findAll() {
        return this.elementRepository.findAll().stream().map(arg_0 -> this.convertToResponseDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<ElementConstitutifResponseDto> findByEnseignantId(Long enseignantId) {
        return this.elementRepository.findByEnseignantId(enseignantId).stream().map(arg_0 -> this.convertToResponseDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<ElementConstitutifResponseDto> findAllWithChapitres() {
        List elements = this.elementRepository.findAll();
        return elements.stream().map(arg_0 -> this.convertToResponseDtoWithChapitres(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<String> findAllNoms() {
        return this.elementRepository.findAll().stream().map(ElementConstitutif::getNom).collect(Collectors.toList());
    }

    @Transactional
    public ElementConstitutifResponseDto update(Long id, ElementConstitutifRequestDto dto) {
        ElementConstitutif ec = (ElementConstitutif)this.elementRepository.findById(id).orElseThrow(() -> new EntityNotFoundException("\u00c9l\u00e9ment non trouv\u00e9 avec l'ID: " + id));
        Utilisateur enseignant = null;
        if (dto.getEnseignantId() != null) {
            enseignant = (Utilisateur)this.utilisateurRepository.findById((Object)dto.getEnseignantId()).orElseThrow(() -> new EntityNotFoundException("Enseignant non trouv\u00e9 avec l'ID: " + dto.getEnseignantId()));
        }
        ec.setNom(dto.getNom());
        ec.setCode(dto.getCode());
        ec.setCredit(dto.getCredit());
        ec.setDescription(dto.getDescription());
        ec.setEnseignant(enseignant);
        ElementConstitutif savedEc = (ElementConstitutif)this.elementRepository.save((Object)ec);
        return this.convertToResponseDto(savedEc);
    }

    @Transactional
    public void deleteById(Long id) {
        if (!this.elementRepository.existsById((Object)id)) {
            throw new EntityNotFoundException("Impossible de supprimer : \u00c9l\u00e9ment non trouv\u00e9 avec l'ID: " + id);
        }
        this.elementRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<ChapitreDto> findChapitresByEcId(Long ecId) {
        ElementConstitutif ec = (ElementConstitutif)this.elementRepository.findById(ecId).orElseThrow(() -> new EntityNotFoundException("\u00c9l\u00e9ment Constitutif non trouv\u00e9 avec l'ID: " + ecId));
        return ec.getChapitres().stream().map(chapitre -> {
            ChapitreDto dto = new ChapitreDto();
            dto.setId(chapitre.getId());
            dto.setNom(chapitre.getNom());
            dto.setNiveau(chapitre.getNiveau());
            dto.setObjectif(chapitre.getObjectif());
            return dto;
        }).collect(Collectors.toList());
    }

    private ElementConstitutifResponseDto convertToResponseDto(ElementConstitutif element) {
        ElementConstitutifResponseDto dto = new ElementConstitutifResponseDto();
        dto.setId(element.getId());
        dto.setNom(element.getNom());
        dto.setCode(element.getCode());
        dto.setDescription(element.getDescription());
        dto.setCredit(element.getCredit().intValue());
        dto.setVolumeHoraireCours(element.getVolumeHoraireCours());
        dto.setVolumeHoraireTD(element.getVolumeHoraireTD());
        dto.setVolumeHoraireTP(element.getVolumeHoraireTP());
        if (element.getEnseignant() != null) {
            EnseignantDto enseignantDto = new EnseignantDto(element.getEnseignant().getId(), element.getEnseignant().getNom(), element.getEnseignant().getPrenom());
            dto.setEnseignant(enseignantDto);
        }
        return dto;
    }

    private ElementConstitutifResponseDto convertToResponseDtoWithChapitres(ElementConstitutif element) {
        ElementConstitutifResponseDto dto = this.convertToResponseDto(element);
        if (element.getChapitres() != null) {
            List chapitreDtos = element.getChapitres().stream().map(chapitre -> {
                ChapitreDto chapitreDto = new ChapitreDto();
                chapitreDto.setId(chapitre.getId());
                chapitreDto.setNom(chapitre.getNom());
                chapitreDto.setObjectif(chapitre.getObjectif());
                chapitreDto.setNiveau(chapitre.getNiveau());
                if (chapitre.getSections() != null) {
                    List sectionDtos = chapitre.getSections().stream().map(SectionDto::new).collect(Collectors.toList());
                    chapitreDto.setSections(sectionDtos);
                } else {
                    chapitreDto.setSections(Collections.emptyList());
                }
                return chapitreDto;
            }).collect(Collectors.toList());
            dto.setChapitres(chapitreDtos);
        } else {
            dto.setChapitres(Collections.emptyList());
        }
        return dto;
    }
}

