/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.EchelleConnaissanceDto;
import com.moscepa.entity.EchelleConnaissance;
import com.moscepa.repository.EchelleConnaissanceRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EchelleConnaissanceService {
    private final EchelleConnaissanceRepository repository;

    public EchelleConnaissanceService(EchelleConnaissanceRepository repository) {
        this.repository = repository;
    }

    public List<EchelleConnaissanceDto> findAll() {
        return this.repository.findAll().stream().map(EchelleConnaissanceDto::new).collect(Collectors.toList());
    }

    @Transactional
    public EchelleConnaissanceDto create(EchelleConnaissanceDto dto) {
        EchelleConnaissance echelle = new EchelleConnaissance();
        echelle.setIntervalle(dto.getIntervalle());
        echelle.setDescription(dto.getDescription());
        echelle.setRecommandation(dto.getRecommandation());
        EchelleConnaissance savedEchelle = (EchelleConnaissance)this.repository.save((Object)echelle);
        return new EchelleConnaissanceDto(savedEchelle);
    }

    @Transactional
    public EchelleConnaissanceDto update(Long id, EchelleConnaissanceDto dto) {
        EchelleConnaissance echelle = (EchelleConnaissance)this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("EchelleConnaissance non trouv\u00e9e avec l'ID: " + id));
        echelle.setIntervalle(dto.getIntervalle());
        echelle.setDescription(dto.getDescription());
        echelle.setRecommandation(dto.getRecommandation());
        EchelleConnaissance updatedEchelle = (EchelleConnaissance)this.repository.save((Object)echelle);
        return new EchelleConnaissanceDto(updatedEchelle);
    }

    @Transactional
    public void delete(Long id) {
        if (!this.repository.existsById((Object)id)) {
            throw new EntityNotFoundException("EchelleConnaissance non trouv\u00e9e avec l'ID: " + id);
        }
        this.repository.deleteById((Object)id);
    }
}

