/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.DepartementDTO;
import com.moscepa.entity.Departement;
import com.moscepa.entity.Formation;
import com.moscepa.entity.Uefr;
import com.moscepa.repository.DepartementRepository;
import com.moscepa.repository.FormationRepository;
import com.moscepa.repository.UefrRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DepartementService {
    @Autowired
    private DepartementRepository departementRepository;
    @Autowired
    private UefrRepository uefrRepository;
    @Autowired
    private FormationRepository formationRepository;

    public List<Departement> getAllDepartements() {
        return this.departementRepository.findAll();
    }

    public Departement getDepartementById(Long id) {
        return (Departement)this.departementRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("D\u00e9partement non trouv\u00e9 avec l'ID: " + id));
    }

    public Departement createDepartement(DepartementDTO departementDTO) {
        if (this.departementRepository.existsBySigle(departementDTO.getSigle())) {
            throw new RuntimeException("Le sigle '" + departementDTO.getSigle() + "' existe d\u00e9j\u00e0");
        }
        Departement departement = new Departement();
        departement.setNom(departementDTO.getNom());
        departement.setSigle(departementDTO.getSigle());
        departement.setAdresse(departementDTO.getAdresse());
        departement.setContact(departementDTO.getContact());
        departement.setLogo(departementDTO.getLogo());
        departement.setLien(departementDTO.getLien());
        Uefr uefr = (Uefr)this.uefrRepository.findById((Object)departementDTO.getUefrId()).orElseThrow(() -> new RuntimeException("UEFR non trouv\u00e9e avec l'ID: " + departementDTO.getUefrId()));
        departement.setUefr(uefr);
        if (departementDTO.getFormationId() != null) {
            Formation formation = (Formation)this.formationRepository.findById((Object)departementDTO.getFormationId()).orElseThrow(() -> new RuntimeException("Formation non trouv\u00e9e avec l'ID: " + departementDTO.getFormationId()));
            departement.setFormation(formation);
        }
        return (Departement)this.departementRepository.save((Object)departement);
    }

    public Departement updateDepartement(Long id, DepartementDTO departementDTO) {
        Long formationId;
        Departement departement = (Departement)this.departementRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("D\u00e9partement non trouv\u00e9 avec l'ID: " + id));
        if (!departement.getSigle().equals(departementDTO.getSigle()) && this.departementRepository.existsBySigle(departementDTO.getSigle())) {
            throw new RuntimeException("Le sigle '" + departementDTO.getSigle() + "' est d\u00e9j\u00e0 utilis\u00e9");
        }
        departement.setNom(departementDTO.getNom());
        departement.setSigle(departementDTO.getSigle());
        departement.setAdresse(departementDTO.getAdresse());
        departement.setContact(departementDTO.getContact());
        departement.setLogo(departementDTO.getLogo());
        departement.setLien(departementDTO.getLien());
        if (!departement.getUefr().getId().equals(departementDTO.getUefrId())) {
            Uefr uefr = (Uefr)this.uefrRepository.findById((Object)departementDTO.getUefrId()).orElseThrow(() -> new RuntimeException("UEFR non trouv\u00e9e avec l'ID: " + departementDTO.getUefrId()));
            departement.setUefr(uefr);
        }
        if ((formationId = departementDTO.getFormationId()) == null) {
            departement.setFormation(null);
        } else if (departement.getFormation() == null || !departement.getFormation().getId().equals(formationId)) {
            Formation formation = (Formation)this.formationRepository.findById((Object)formationId).orElseThrow(() -> new RuntimeException("Formation non trouv\u00e9e avec l'ID: " + formationId));
            departement.setFormation(formation);
        }
        return (Departement)this.departementRepository.save((Object)departement);
    }

    public void deleteDepartement(Long id) {
        if (!this.departementRepository.existsById((Object)id)) {
            throw new RuntimeException("D\u00e9partement non trouv\u00e9 avec l'ID: " + id);
        }
        this.departementRepository.deleteById((Object)id);
    }

    public Page<Departement> search(String searchTerm, Long uefrId, Pageable pageable) {
        if ((searchTerm == null || searchTerm.trim().isEmpty()) && uefrId == null) {
            return this.departementRepository.findAll(pageable);
        }
        return this.departementRepository.search(searchTerm != null && !searchTerm.trim().isEmpty() ? searchTerm.trim() : null, uefrId, pageable);
    }

    public Page<Departement> search(String searchTerm, Long uefrId, Long formationId, Pageable pageable) {
        if ((searchTerm == null || searchTerm.trim().isEmpty()) && uefrId == null && formationId == null) {
            return this.departementRepository.findAll(pageable);
        }
        return this.departementRepository.search(searchTerm != null && !searchTerm.trim().isEmpty() ? searchTerm.trim() : null, uefrId, formationId, pageable);
    }

    public boolean existsBySigle(String sigle) {
        return this.departementRepository.existsBySigle(sigle);
    }

    public boolean existsBySigleAndIdNot(String sigle, Long id) {
        return this.departementRepository.existsBySigleAndIdNot(sigle, id);
    }
}

