/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ChapitreAvecSectionsDto;
import com.moscepa.dto.ChapitreContenuDto;
import com.moscepa.dto.ChapitreCreateDto;
import com.moscepa.dto.ChapitreDetailDto;
import com.moscepa.dto.ChapitrePayload;
import com.moscepa.dto.QuestionDto;
import com.moscepa.dto.SectionPayload;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.ResultatTest;
import com.moscepa.entity.Section;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.ElementConstitutifRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChapitreService {
    private static final Logger log = LoggerFactory.getLogger(ChapitreService.class);
    @Autowired
    private ChapitreRepository chapitreRepository;
    @Autowired
    private ElementConstitutifRepository ecRepository;

    @Transactional(readOnly=true)
    public ChapitreDetailDto getChapitreDetailsPourTest(Long id) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID: " + id));
        return new ChapitreDetailDto(chapitre);
    }

    @Transactional
    public ChapitreDetailDto creerChapitreAvecNomMatiere(ChapitrePayload payload) {
        ElementConstitutif ecParent = (ElementConstitutif)this.ecRepository.findByNom(payload.getMatiere()).orElseThrow(() -> new EntityNotFoundException("Mati\u00e8re non trouv\u00e9e avec le nom: " + payload.getMatiere()));
        Chapitre nouveauChapitre = new Chapitre();
        nouveauChapitre.setNom(payload.getTitre());
        nouveauChapitre.setObjectif(payload.getObjectif());
        nouveauChapitre.setNiveau(payload.getNiveau());
        nouveauChapitre.setElementConstitutif(ecParent);
        nouveauChapitre.setTypeActivite(payload.getTypeActivite());
        nouveauChapitre.setPrerequis(payload.getPrerequis());
        nouveauChapitre.setTypeEvaluation(payload.getTypeEvaluation());
        if (payload.getSections() != null) {
            int ordreCompteur = 1;
            for (SectionPayload sectionPayload : payload.getSections()) {
                Section nouvelleSection = new Section();
                nouvelleSection.setTitre(sectionPayload.getTitre());
                nouvelleSection.setContenu("");
                nouvelleSection.setOrdre(Integer.valueOf(ordreCompteur++));
                nouveauChapitre.addSection(nouvelleSection);
            }
        }
        Chapitre chapitreSauvegarde = (Chapitre)this.chapitreRepository.save((Object)nouveauChapitre);
        return new ChapitreDetailDto(chapitreSauvegarde);
    }

    @Transactional(readOnly=true)
    public Optional<ChapitreAvecSectionsDto> findChapitreCompletByMatiereAndNiveau(String matiereNom, Integer niveau) {
        return this.chapitreRepository.findByElementConstitutifNomAndNiveau(matiereNom, niveau).map(ChapitreAvecSectionsDto::new);
    }

    @Transactional(readOnly=true)
    public Optional<ChapitreDetailDto> findByMatiereNomAndNiveau(String matiereNom, Integer niveau) {
        return this.chapitreRepository.findByElementConstitutifNomAndNiveau(matiereNom, niveau).map(ChapitreDetailDto::new);
    }

    @Transactional(readOnly=true)
    public List<QuestionDto> getQuestionsPourChapitre(Long chapitreId) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID: " + chapitreId));
        return chapitre.getQuestionnaires().stream().flatMap(questionnaire -> questionnaire.getQuestions().stream()).map(QuestionDto::new).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<ChapitreDetailDto> getChapitreDetailsById(Long id) {
        return this.chapitreRepository.findById((Object)id).map(ChapitreDetailDto::new);
    }

    @Transactional(readOnly=true)
    public Optional<ChapitreAvecSectionsDto> findChapitreCompletById(Long id) {
        return this.chapitreRepository.findChapitreCompletById(id).map(ChapitreAvecSectionsDto::new);
    }

    @Transactional(readOnly=true)
    public List<ChapitreContenuDto> findContenuCompletPourMatiere(Long matiereId) {
        if (!this.ecRepository.existsById((Object)matiereId)) {
            throw new EntityNotFoundException("Mati\u00e8re non trouv\u00e9e avec l'ID: " + matiereId);
        }
        List chapitres = this.chapitreRepository.findAllChapitresCompletsByMatiereId(matiereId);
        return chapitres.stream().map(ChapitreContenuDto::new).collect(Collectors.toList());
    }

    @Transactional
    public ChapitreContenuDto createChapitre(Long matiereId, ChapitreCreateDto dto) {
        ElementConstitutif matiere = (ElementConstitutif)this.ecRepository.findById(matiereId).orElseThrow(() -> new EntityNotFoundException("Mati\u00e8re non trouv\u00e9e avec l'ID: " + matiereId));
        Integer nouvelOrdre = this.chapitreRepository.countByElementConstitutifId(matiereId) + 1;
        Chapitre nouveauChapitre = new Chapitre();
        nouveauChapitre.setNom(dto.nom);
        nouveauChapitre.setObjectif(dto.objectif);
        nouveauChapitre.setOrdre(nouvelOrdre);
        nouveauChapitre.setElementConstitutif(matiere);
        Chapitre chapitreSauvegarde = (Chapitre)this.chapitreRepository.save((Object)nouveauChapitre);
        return new ChapitreContenuDto(chapitreSauvegarde);
    }

    @Transactional
    public void deleteChapitre(Long chapitreId) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Impossible de supprimer : Chapitre non trouv\u00e9 avec l'ID: " + chapitreId));
        boolean hasResults = chapitre.getTests().stream().anyMatch(test -> test.getResultats() != null && !test.getResultats().isEmpty());
        if (hasResults) {
            throw new IllegalStateException("Suppression refus\u00e9e : des r\u00e9sultats de tests existent pour ce chapitre.");
        }
        this.chapitreRepository.delete((Object)chapitre);
        log.info("Chapitre avec l'ID {} supprim\u00e9 avec succ\u00e8s.", (Object)chapitreId);
    }

    @Transactional(readOnly=true)
    public List<ResultatTest> getResultatsPourChapitre(Long chapitreId) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID: " + chapitreId));
        return chapitre.getTests().stream().flatMap(test -> test.getResultats().stream()).collect(Collectors.toList());
    }
}

