/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.CategorieDto;
import com.moscepa.entity.Categorie;
import com.moscepa.entity.EchelleConnaissance;
import com.moscepa.repository.CategorieRepository;
import com.moscepa.repository.EchelleConnaissanceRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CategorieService {
    private final CategorieRepository categorieRepository;
    private final EchelleConnaissanceRepository echelleRepository;

    public CategorieService(CategorieRepository categorieRepository, EchelleConnaissanceRepository echelleRepository) {
        this.categorieRepository = categorieRepository;
        this.echelleRepository = echelleRepository;
    }

    public List<CategorieDto> findAll() {
        return this.categorieRepository.findAll().stream().map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
    }

    public CategorieDto findById(Long id) {
        return this.categorieRepository.findById((Object)id).map(arg_0 -> this.toDto(arg_0)).orElse(null);
    }

    public CategorieDto create(CategorieDto dto) {
        EchelleConnaissance echelle = (EchelleConnaissance)this.echelleRepository.findById((Object)dto.getEchelleId()).orElseThrow(() -> new RuntimeException("\u00c9chelle non trouv\u00e9e"));
        Categorie categorie = new Categorie();
        categorie.setNom(dto.getNom());
        categorie.setEchelleConnaissance(echelle);
        Categorie saved = (Categorie)this.categorieRepository.save((Object)categorie);
        return this.toDto(saved);
    }

    public CategorieDto update(Long id, CategorieDto dto) {
        Categorie categorie = (Categorie)this.categorieRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Cat\u00e9gorie non trouv\u00e9e"));
        EchelleConnaissance echelle = (EchelleConnaissance)this.echelleRepository.findById((Object)dto.getEchelleId()).orElseThrow(() -> new RuntimeException("\u00c9chelle non trouv\u00e9e"));
        categorie.setNom(dto.getNom());
        categorie.setEchelleConnaissance(echelle);
        Categorie updated = (Categorie)this.categorieRepository.save((Object)categorie);
        return this.toDto(updated);
    }

    public void delete(Long id) {
        this.categorieRepository.deleteById((Object)id);
    }

    private CategorieDto toDto(Categorie categorie) {
        CategorieDto dto = new CategorieDto();
        dto.setId(categorie.getId());
        dto.setNom(categorie.getNom());
        dto.setEchelleId(categorie.getEchelleConnaissance().getId());
        dto.setEchelleIntervalle(categorie.getEchelleConnaissance().getIntervalle());
        return dto;
    }
}

