/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.BanqueQuestionCreationDto;
import com.moscepa.dto.BanqueQuestionDetailDto;
import com.moscepa.entity.BanqueQuestion;
import com.moscepa.entity.BanqueReponse;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.StatutQuestion;
import com.moscepa.entity.Tag;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.BanqueQuestionRepository;
import com.moscepa.repository.BanqueReponseRepository;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.TagRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.UserPrincipal;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BanqueQuestionService {
    private final BanqueQuestionRepository banqueQuestionRepository;
    private final BanqueReponseRepository banqueReponseRepository;
    private final ChapitreRepository chapitreRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final TagRepository tagRepository;

    public BanqueQuestionService(BanqueQuestionRepository banqueQuestionRepository, BanqueReponseRepository banqueReponseRepository, ChapitreRepository chapitreRepository, UtilisateurRepository utilisateurRepository, TagRepository tagRepository) {
        this.banqueQuestionRepository = banqueQuestionRepository;
        this.banqueReponseRepository = banqueReponseRepository;
        this.chapitreRepository = chapitreRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.tagRepository = tagRepository;
    }

    @Transactional
    public BanqueQuestionDetailDto creerQuestion(BanqueQuestionCreationDto dto) {
        return this.sauvegarderQuestion(new BanqueQuestion(), dto);
    }

    @Transactional
    public BanqueQuestionDetailDto mettreAJourQuestion(Long id, BanqueQuestionCreationDto dto) {
        BanqueQuestion question = (BanqueQuestion)this.banqueQuestionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question de banque non trouv\u00e9e avec l'ID: " + id));
        return this.sauvegarderQuestion(question, dto);
    }

    private BanqueQuestionDetailDto sauvegarderQuestion(BanqueQuestion question, BanqueQuestionCreationDto dto) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)dto.getChapitreId()).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID: " + dto.getChapitreId()));
        UserPrincipal userPrincipal = (UserPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Utilisateur auteur = (Utilisateur)this.utilisateurRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new EntityNotFoundException("Auteur non trouv\u00e9."));
        question.setEnonce(dto.getEnonce());
        question.setTypeQuestion(dto.getTypeQuestion());
        question.setPoints(dto.getPoints());
        question.setDifficulte(dto.getDifficulte());
        question.setChapitre(chapitre);
        if (question.getId() == null) {
            question.setAuteur(auteur);
            question.setStatut(StatutQuestion.BROUILLON);
        }
        Set tags = dto.getTags().stream().map(nom -> this.tagRepository.findByNomIgnoreCase(nom).orElseGet(() -> {
            Tag newTag = new Tag(nom);
            return (Tag)this.tagRepository.save((Object)newTag);
        })).collect(Collectors.toSet());
        question.setTags(tags);
        question.getReponses().clear();
        dto.getReponses().forEach(reponseDto -> {
            BanqueReponse reponse = new BanqueReponse();
            reponse.setTexte(reponseDto.getTexte());
            reponse.setCorrecte(reponseDto.getCorrecte());
            reponse.setBanqueQuestion(question);
            question.getReponses().add(reponse);
        });
        BanqueQuestion questionSauvegardee = (BanqueQuestion)this.banqueQuestionRepository.save((Object)question);
        return new BanqueQuestionDetailDto(questionSauvegardee);
    }

    public BanqueQuestionDetailDto getQuestionById(Long id) {
        BanqueQuestion question = (BanqueQuestion)this.banqueQuestionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question de banque non trouv\u00e9e avec l'ID: " + id));
        return new BanqueQuestionDetailDto(question);
    }

    public List<BanqueQuestionDetailDto> getAllQuestions() {
        return this.banqueQuestionRepository.findAll().stream().map(BanqueQuestionDetailDto::new).collect(Collectors.toList());
    }

    @Transactional
    public void supprimerQuestion(Long id) {
        BanqueQuestion question = (BanqueQuestion)this.banqueQuestionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question de banque non trouv\u00e9e avec l'ID: " + id));
        this.banqueQuestionRepository.delete((Object)question);
    }

    @Transactional
    public void mettreAJourStatistiques(Long questionId, boolean reponseCorrecte) {
        BanqueQuestion question = (BanqueQuestion)this.banqueQuestionRepository.findById((Object)questionId).orElseThrow(() -> new EntityNotFoundException("Question de banque non trouv\u00e9e avec l'ID: " + questionId));
        question.incrementerUtilisations();
        this.banqueQuestionRepository.save((Object)question);
    }
}

