/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.LoginRequest;
import com.moscepa.dto.LoginResponse;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.JwtUtils;
import com.moscepa.security.UserPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthService {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UtilisateurRepository utilisateurRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JwtUtils jwtUtils;

    public LoginResponse authenticateUser(LoginRequest loginRequest) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getEmail(), (Object)loginRequest.getMotDePasse()));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String jwt = this.jwtUtils.generateJwtToken(authentication);
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Utilisateur utilisateur = (Utilisateur)this.utilisateurRepository.findByEmail(userPrincipal.getEmail()).orElseThrow(() -> new RuntimeException("Utilisateur non trouv\u00e9"));
        return new LoginResponse(jwt, utilisateur.getId(), utilisateur.getEmail(), utilisateur.getNom(), utilisateur.getPrenom(), utilisateur.getRole());
    }

    public boolean existsByEmail(String email) {
        return this.utilisateurRepository.existsByEmail(email);
    }

    public String encodePassword(String password) {
        return this.passwordEncoder.encode((CharSequence)password);
    }

    public Utilisateur getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
            return (Utilisateur)this.utilisateurRepository.findByEmail(userPrincipal.getEmail()).orElseThrow(() -> new RuntimeException("Utilisateur non trouv\u00e9"));
        }
        throw new RuntimeException("Aucun utilisateur connect\u00e9");
    }

    public boolean hasPermission(String permissionName) {
        try {
            Utilisateur currentUser = this.getCurrentUser();
            return currentUser.getPermissions().stream().anyMatch(permission -> permission.getNom().equals(permissionName));
        }
        catch (Exception e) {
            return false;
        }
    }
}

