/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.security;

import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    @Autowired
    private UtilisateurRepository utilisateurRepository;

    @Transactional
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        logger.info("[PI\u00c8GE - UserDetailsService] Entr\u00e9e dans loadUserByUsername pour l'email : '{}'", (Object)email);
        try {
            logger.info("[PI\u00c8GE - UserDetailsService] \u00c9tape 1: Recherche de l'utilisateur en base de donn\u00e9es...");
            Utilisateur utilisateur = (Utilisateur)this.utilisateurRepository.findByEmail(email).orElseThrow(() -> {
                logger.error("[PI\u00c8GE - UserDetailsService] \u274c ERREUR : Utilisateur NON TROUV\u00c9 en BDD pour l'email : '{}'", (Object)email);
                return new UsernameNotFoundException("Utilisateur non trouv\u00e9 avec l'email: " + email);
            });
            logger.info("[PI\u00c8GE - UserDetailsService] \u00c9tape 2: Utilisateur trouv\u00e9 ! ID: {}, Email: {}", (Object)utilisateur.getId(), (Object)utilisateur.getEmail());
            if (!utilisateur.getActif().booleanValue()) {
                logger.error("[PI\u00c8GE - UserDetailsService] \u274c ERREUR : Le compte de l'utilisateur '{}' est D\u00c9SACTIV\u00c9.", (Object)email);
                throw new UsernameNotFoundException("Compte utilisateur d\u00e9sactiv\u00e9: " + email);
            }
            logger.info("[PI\u00c8GE - UserDetailsService] \u00c9tape 3: Le compte est bien ACTIF.");
            logger.info("[PI\u00c8GE - UserDetailsService] \u00c9tape 4: Tentative de construction de l'objet UserPrincipal...");
            UserPrincipal userPrincipal = UserPrincipal.create((Utilisateur)utilisateur);
            logger.info("[PI\u00c8GE - UserDetailsService] \u2705 SUCC\u00c8S : UserPrincipal construit. L'utilisateur a les r\u00f4les : {}", (Object)userPrincipal.getAuthorities());
            return userPrincipal;
        }
        catch (UsernameNotFoundException e) {
            logger.error("[PI\u00c8GE - UserDetailsService] Exception de type UsernameNotFoundException attrap\u00e9e et relanc\u00e9e.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("[PI\u00c8GE - UserDetailsService] \u274c ERREUR INATTENDUE (EXCEPTION CACH\u00c9E ?) lors du traitement de l'email '{}' :", (Object)email, (Object)e);
            throw new UsernameNotFoundException("Erreur interne inattendue lors de la construction des d\u00e9tails de l'utilisateur.", (Throwable)e);
        }
    }
}

