/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.repository;

import com.moscepa.entity.Question;
import com.moscepa.entity.Questionnaire;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface QuestionRepository
extends JpaRepository<Question, Long> {
    @Query(value="SELECT id, date_creation, date_modification, enonce AS question_text, difficulte AS niveau, type_question, points, statut, nombre_utilisations, note_qualite, taux_reussite, auteur_id, chapitre_id, NULL AS questionnaire_id, NULL AS reponse_correcte_texte, NULL AS theme FROM moscepa_banque_questions WHERE chapitre_id = :chapitreId AND difficulte = :difficulte", nativeQuery=true)
    public List<Question> findByChapitreIdAndDifficulteNative(@Param(value="chapitreId") Long var1, @Param(value="difficulte") String var2);

    @Query(value="SELECT q FROM Question q LEFT JOIN FETCH q.reponses WHERE q.questionnaire.chapitre.id = :chapitreId")
    public List<Question> findByQuestionnaireChapitreId(@Param(value="chapitreId") Long var1);

    @Query(value="SELECT q FROM Question q JOIN q.questionnaire qn JOIN qn.chapitre c WHERE c.elementConstitutif.id = :matiereId")
    public List<Question> findQuestionsByMatiereId(@Param(value="matiereId") Long var1);

    @Query(value="SELECT q FROM Question q LEFT JOIN FETCH q.reponses WHERE q.questionnaire IS NULL AND q.chapitre.id = :chapitreId")
    public List<Question> findBanqueQuestionsByChapitreId(@Param(value="chapitreId") Long var1);

    @Query(value="SELECT q FROM Question q WHERE q.questionnaire IS NULL")
    public List<Question> findBanqueQuestions();

    @Query(value="SELECT q FROM Question q LEFT JOIN FETCH q.reponses WHERE q.id = :id")
    public Optional<Question> findByIdWithReponses(@Param(value="id") Long var1);

    public List<Question> findByQuestionnaire_Id(Long var1);

    public List<Question> findByChapitreId(Long var1);

    @Query(value="SELECT q FROM Questionnaire q LEFT JOIN FETCH q.questions qu LEFT JOIN FETCH qu.reponses WHERE q.id = :id")
    public Optional<Questionnaire> findByIdWithQuestions(@Param(value="id") Long var1);

    @Query(value="SELECT DISTINCT q FROM Question q LEFT JOIN FETCH q.reponses WHERE q.id IN :ids")
    public List<Question> findAllWithReponsesByIds(@Param(value="ids") List<Long> var1);
}

