/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.Question;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.ResultatTest;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="moscepa_tests")
public class Test {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String titre;
    @Column
    private Integer duree;
    @Column(columnDefinition="TEXT")
    private String description;
    @Column(name="tentatives_max")
    private Integer tentativesMax = 1;
    @Column(name="tentatives_illimitees")
    private Boolean tentativesIllimitees = false;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chapitre_id", nullable=false)
    @JsonBackReference(value="chapitre-tests")
    private Chapitre chapitre;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="questionnaire_id")
    @JsonBackReference(value="questionnaire-tests")
    private Questionnaire questionnaire;
    @ManyToMany
    @JoinTable(name="moscepa_test_questions", joinColumns={@JoinColumn(name="test_id")}, inverseJoinColumns={@JoinColumn(name="question_id")})
    @JsonManagedReference(value="test-questions")
    private List<Question> questions = new ArrayList();
    @OneToMany(mappedBy="test", cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JsonManagedReference(value="test-resultats")
    private List<ResultatTest> resultats = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="element_constitutif_id")
    @JsonBackReference(value="elementConstitutif-tests")
    private ElementConstitutif elementConstitutif;

    public void addQuestion(Question question) {
        this.questions.add(question);
        if (!question.getTests().contains(this)) {
            question.getTests().add(this);
        }
    }

    public void removeQuestion(Question question) {
        this.questions.remove(question);
        question.getTests().remove(this);
    }

    public void addResultat(ResultatTest resultat) {
        this.resultats.add(resultat);
        resultat.setTest(this);
    }

    public void removeResultat(ResultatTest resultat) {
        this.resultats.remove(resultat);
        resultat.setTest(null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public Integer getDuree() {
        return this.duree;
    }

    public void setDuree(Integer duree) {
        this.duree = duree;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getTentativesMax() {
        return this.tentativesMax;
    }

    public void setTentativesMax(Integer tentativesMax) {
        if (tentativesMax != null && tentativesMax >= 0) {
            this.tentativesMax = tentativesMax;
        }
    }

    public Boolean getTentativesIllimitees() {
        return this.tentativesIllimitees;
    }

    public void setTentativesIllimitees(Boolean tentativesIllimitees) {
        this.tentativesIllimitees = tentativesIllimitees != null && tentativesIllimitees != false;
    }

    public Chapitre getChapitre() {
        return this.chapitre;
    }

    public void setChapitre(Chapitre chapitre) {
        this.chapitre = chapitre;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public List<ResultatTest> getResultats() {
        return this.resultats;
    }

    public void setResultats(List<ResultatTest> resultats) {
        this.resultats = resultats;
    }

    public ElementConstitutif getElementConstitutif() {
        return this.elementConstitutif;
    }

    public void setElementConstitutif(ElementConstitutif elementConstitutif) {
        this.elementConstitutif = elementConstitutif;
    }

    public String toString() {
        return "Test{id=" + this.id + ", titre='" + this.titre + "', duree=" + this.duree + ", description='" + this.description + "', tentativesMax=" + this.tentativesMax + ", tentativesIllimitees=" + this.tentativesIllimitees + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Test test = (Test)o;
        return this.id != null && this.id.equals(test.id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

