/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.moscepa.entity.RecommandationChapitre;
import com.moscepa.entity.TypeRessource;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;

@Entity
@Table(name="moscepa_ressources")
public class Ressource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private TypeRessource type;
    @NotBlank(message="Le titre de la ressource est obligatoire")
    @Size(max=200)
    @Column(name="titre", nullable=false, length=200)
    private @NotBlank(message="Le titre de la ressource est obligatoire") @Size(max=200) String titre;
    @NotBlank(message="Le lien de la ressource est obligatoire")
    @Size(max=500)
    @Column(name="lien", nullable=false, length=500)
    private @NotBlank(message="Le lien de la ressource est obligatoire") @Size(max=500) String lien;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="recommandation_id")
    private RecommandationChapitre recommandation;

    public Ressource() {
    }

    public Ressource(TypeRessource type, String titre, String lien) {
        this.type = type;
        this.titre = titre;
        this.lien = lien;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TypeRessource getType() {
        return this.type;
    }

    public void setType(TypeRessource type) {
        this.type = type;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public String getLien() {
        return this.lien;
    }

    public void setLien(String lien) {
        this.lien = lien;
    }

    public RecommandationChapitre getRecommandation() {
        return this.recommandation;
    }

    public void setRecommandation(RecommandationChapitre recommandation) {
        this.recommandation = recommandation;
    }

    public String toString() {
        return "Ressource{id=" + this.id + ", type=" + String.valueOf(this.type) + ", titre='" + this.titre + "', lien='" + this.lien + "'}";
    }
}

