/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.moscepa.entity.Chapitre;
import com.moscepa.entity.NiveauDifficulte;
import com.moscepa.entity.Ressource;
import com.moscepa.entity.StatutRecommandation;
import com.moscepa.entity.Utilisateur;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="moscepa_recommandations_chapitres")
public class RecommandationChapitre {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="etudiant_id", nullable=false)
    private Utilisateur etudiant;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chapitre_id", nullable=false)
    private Chapitre chapitre;
    @NotBlank(message="Le nom du chapitre est obligatoire")
    @Size(max=150)
    @Column(name="nom_chapitre", nullable=false, length=150)
    private @NotBlank(message="Le nom du chapitre est obligatoire") @Size(max=150) String nomChapitre;
    @NotBlank(message="Le nom de la mati\u00e8re est obligatoire")
    @Size(max=100)
    @Column(name="matiere", nullable=false, length=100)
    private @NotBlank(message="Le nom de la mati\u00e8re est obligatoire") @Size(max=100) String matiere;
    @NotNull(message="Le score est obligatoire")
    @Column(name="score", nullable=false)
    private @NotNull(message="Le score est obligatoire") Double score;
    @Size(max=500)
    @Column(name="raison", length=500)
    private @Size(max=500) String raison;
    @Enumerated(value=EnumType.STRING)
    @Column(name="niveau", nullable=false)
    private NiveauDifficulte niveau;
    @NotNull(message="La progression est obligatoire")
    @Column(name="progression", nullable=false)
    private @NotNull(message="La progression est obligatoire") Integer progression = 0;
    @Size(max=50)
    @Column(name="duree_estimee", length=50)
    private @Size(max=50) String dureeEstimee;
    @Enumerated(value=EnumType.STRING)
    @Column(name="statut", nullable=false)
    private StatutRecommandation statut = StatutRecommandation.NON_COMMENCE;
    @CreationTimestamp
    @Column(name="date_recommandation", nullable=false, updatable=false)
    private LocalDateTime dateRecommandation;
    @OneToMany(mappedBy="recommandation", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Ressource> ressources = new ArrayList();

    public RecommandationChapitre() {
    }

    public RecommandationChapitre(Utilisateur etudiant, Chapitre chapitre, String nomChapitre, String matiere, Double score, String raison, NiveauDifficulte niveau) {
        this.etudiant = etudiant;
        this.chapitre = chapitre;
        this.nomChapitre = nomChapitre;
        this.matiere = matiere;
        this.score = score;
        this.raison = raison;
        this.niveau = niveau;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Utilisateur getEtudiant() {
        return this.etudiant;
    }

    public void setEtudiant(Utilisateur etudiant) {
        this.etudiant = etudiant;
    }

    public Chapitre getChapitre() {
        return this.chapitre;
    }

    public void setChapitre(Chapitre chapitre) {
        this.chapitre = chapitre;
    }

    public String getNomChapitre() {
        return this.nomChapitre;
    }

    public void setNomChapitre(String nomChapitre) {
        this.nomChapitre = nomChapitre;
    }

    public String getMatiere() {
        return this.matiere;
    }

    public void setMatiere(String matiere) {
        this.matiere = matiere;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public String getRaison() {
        return this.raison;
    }

    public void setRaison(String raison) {
        this.raison = raison;
    }

    public NiveauDifficulte getNiveau() {
        return this.niveau;
    }

    public void setNiveau(NiveauDifficulte niveau) {
        this.niveau = niveau;
    }

    public Integer getProgression() {
        return this.progression;
    }

    public void setProgression(Integer progression) {
        this.progression = progression;
    }

    public String getDureeEstimee() {
        return this.dureeEstimee;
    }

    public void setDureeEstimee(String dureeEstimee) {
        this.dureeEstimee = dureeEstimee;
    }

    public StatutRecommandation getStatut() {
        return this.statut;
    }

    public void setStatut(StatutRecommandation statut) {
        this.statut = statut;
    }

    public LocalDateTime getDateRecommandation() {
        return this.dateRecommandation;
    }

    public void setDateRecommandation(LocalDateTime dateRecommandation) {
        this.dateRecommandation = dateRecommandation;
    }

    public List<Ressource> getRessources() {
        return this.ressources;
    }

    public void setRessources(List<Ressource> ressources) {
        this.ressources = ressources;
    }

    public String toString() {
        return "RecommandationChapitre{id=" + this.id + ", nomChapitre='" + this.nomChapitre + "', matiere='" + this.matiere + "', score=" + this.score + ", niveau=" + String.valueOf(this.niveau) + ", statut=" + String.valueOf(this.statut) + "}";
    }
}

