/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.Section;
import com.moscepa.entity.Test;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="moscepa_chapitres")
public class Chapitre {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="parcours_type")
    private String parcoursType;
    @NotBlank
    private String nom;
    private Integer numero;
    private Integer niveau;
    @Lob
    private String objectif;
    @Column(name="ordre")
    private Integer ordre;
    @Column(name="type_activite")
    private String typeActivite;
    @Lob
    private String prerequis;
    @Column(name="type_evaluation")
    private String typeEvaluation;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="element_constitutif_id", nullable=false)
    @JsonBackReference
    private ElementConstitutif elementConstitutif;
    @OneToMany(mappedBy="chapitre", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<Section> sections = new ArrayList();
    @OneToMany(mappedBy="chapitre", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<Questionnaire> questionnaires = new ArrayList();
    @OneToMany(mappedBy="chapitre", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<Test> tests = new ArrayList();

    public void addSection(Section section) {
        this.sections.add(section);
        section.setChapitre(this);
    }

    public String getParcoursType() {
        return this.parcoursType;
    }

    public void setParcoursType(String parcoursType) {
        this.parcoursType = parcoursType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    public Integer getNiveau() {
        return this.niveau;
    }

    public void setNiveau(Integer niveau) {
        this.niveau = niveau;
    }

    public String getObjectif() {
        return this.objectif;
    }

    public void setObjectif(String objectif) {
        this.objectif = objectif;
    }

    public Integer getOrdre() {
        return this.ordre;
    }

    public void setOrdre(Integer ordre) {
        this.ordre = ordre;
    }

    public String getTypeActivite() {
        return this.typeActivite;
    }

    public void setTypeActivite(String typeActivite) {
        this.typeActivite = typeActivite;
    }

    public String getPrerequis() {
        return this.prerequis;
    }

    public void setPrerequis(String prerequis) {
        this.prerequis = prerequis;
    }

    public String getTypeEvaluation() {
        return this.typeEvaluation;
    }

    public void setTypeEvaluation(String typeEvaluation) {
        this.typeEvaluation = typeEvaluation;
    }

    public ElementConstitutif getElementConstitutif() {
        return this.elementConstitutif;
    }

    public void setElementConstitutif(ElementConstitutif elementConstitutif) {
        this.elementConstitutif = elementConstitutif;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public List<Questionnaire> getQuestionnaires() {
        return this.questionnaires;
    }

    public void setQuestionnaires(List<Questionnaire> questionnaires) {
        this.questionnaires = questionnaires;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }
}

