/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.dto;

import com.moscepa.dto.BanqueReponseDetailDto;
import com.moscepa.entity.BanqueQuestion;
import com.moscepa.entity.Difficulte;
import com.moscepa.entity.TypeQuestion;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BanqueQuestionDetailDto {
    private Long id;
    private String enonce;
    private TypeQuestion typeQuestion;
    private Integer points;
    private Difficulte difficulte;
    private Long chapitreId;
    private String chapitreNom;
    private String auteurNom;
    private LocalDateTime dateCreation;
    private Double noteQualite;
    private Integer nombreUtilisations;
    private List<BanqueReponseDetailDto> reponses;
    private Set<String> tags;

    public BanqueQuestionDetailDto(BanqueQuestion question) {
        this.id = question.getId();
        this.enonce = question.getEnonce();
        this.typeQuestion = question.getTypeQuestion();
        this.points = question.getPoints();
        this.difficulte = question.getDifficulte();
        this.chapitreId = question.getChapitre().getId();
        this.chapitreNom = question.getChapitre().getNom();
        this.auteurNom = question.getAuteur().getPrenom() + " " + question.getAuteur().getNom();
        this.dateCreation = question.getDateCreation();
        this.noteQualite = question.getNoteQualite();
        this.nombreUtilisations = question.getNombreUtilisations();
        this.reponses = question.getReponses().stream().map(BanqueReponseDetailDto::new).collect(Collectors.toList());
        this.tags = question.getTags().stream().map(tag -> tag.getNom()).collect(Collectors.toSet());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEnonce() {
        return this.enonce;
    }

    public void setEnonce(String enonce) {
        this.enonce = enonce;
    }

    public TypeQuestion getTypeQuestion() {
        return this.typeQuestion;
    }

    public void setTypeQuestion(TypeQuestion typeQuestion) {
        this.typeQuestion = typeQuestion;
    }

    public Integer getPoints() {
        return this.points;
    }

    public void setPoints(Integer points) {
        this.points = points;
    }

    public Difficulte getDifficulte() {
        return this.difficulte;
    }

    public void setDifficulte(Difficulte difficulte) {
        this.difficulte = difficulte;
    }

    public Long getChapitreId() {
        return this.chapitreId;
    }

    public void setChapitreId(Long chapitreId) {
        this.chapitreId = chapitreId;
    }

    public String getChapitreNom() {
        return this.chapitreNom;
    }

    public void setChapitreNom(String chapitreNom) {
        this.chapitreNom = chapitreNom;
    }

    public String getAuteurNom() {
        return this.auteurNom;
    }

    public void setAuteurNom(String auteurNom) {
        this.auteurNom = auteurNom;
    }

    public LocalDateTime getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(LocalDateTime dateCreation) {
        this.dateCreation = dateCreation;
    }

    public Double getNoteQualite() {
        return this.noteQualite;
    }

    public void setNoteQualite(Double noteQualite) {
        this.noteQualite = noteQualite;
    }

    public Integer getNombreUtilisations() {
        return this.nombreUtilisations;
    }

    public void setNombreUtilisations(Integer nombreUtilisations) {
        this.nombreUtilisations = nombreUtilisations;
    }

    public List<BanqueReponseDetailDto> getReponses() {
        return this.reponses;
    }

    public void setReponses(List<BanqueReponseDetailDto> reponses) {
        this.reponses = reponses;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }
}

