/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.UefrDTO;
import com.moscepa.service.UefrService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/uefrs"})
@Tag(name="UEFRs", description="API de gestion des Unit\u00e9s d'Enseignement et de Formation de Recherche")
@CrossOrigin(origins={"http://localhost:4200"})
public class UefrController {
    private final UefrService uefrService;

    @Autowired
    public UefrController(UefrService uefrService) {
        this.uefrService = uefrService;
    }

    @GetMapping
    @Operation(summary="R\u00e9cup\u00e9rer toutes les UEFRs")
    public ResponseEntity<List<UefrDTO>> getAllUefrs() {
        List uefrs = this.uefrService.getAllUefrs();
        return ResponseEntity.ok((Object)uefrs);
    }

    @GetMapping(value={"/etablissement/{etablissementId}"})
    @Operation(summary="R\u00e9cup\u00e9rer les UEFRs par \u00e9tablissement")
    public ResponseEntity<List<UefrDTO>> getUefrsByEtablissementId(@PathVariable Long etablissementId) {
        List uefrs = this.uefrService.getUefrsByEtablissementId(etablissementId);
        return ResponseEntity.ok((Object)uefrs);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="R\u00e9cup\u00e9rer une UEFR par son ID")
    public ResponseEntity<UefrDTO> getUefrById(@PathVariable Long id) {
        UefrDTO uefr = this.uefrService.getUefrById(id);
        return ResponseEntity.ok((Object)uefr);
    }

    @PostMapping
    @Operation(summary="Cr\u00e9er une nouvelle UEFR")
    public ResponseEntity<UefrDTO> createUefr(@Valid @RequestBody UefrDTO uefrDTO) {
        UefrDTO createdUefr = this.uefrService.createUefr(uefrDTO);
        return new ResponseEntity((Object)createdUefr, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Mettre \u00e0 jour une UEFR")
    public ResponseEntity<UefrDTO> updateUefr(@PathVariable Long id, @Valid @RequestBody UefrDTO uefrDTO) {
        UefrDTO updatedUefr = this.uefrService.updateUefr(id, uefrDTO);
        return ResponseEntity.ok((Object)updatedUefr);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Supprimer une UEFR")
    public ResponseEntity<Void> deleteUefr(@PathVariable Long id) {
        this.uefrService.deleteUefr(id);
        return ResponseEntity.noContent().build();
    }
}

