/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.QuestionDiagnosticDto;
import com.moscepa.dto.ResultatDiagnosticDto;
import com.moscepa.dto.SoumissionTestDto;
import com.moscepa.service.TestService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/diagnostic"})
public class TestDiagnosticController {
    private static final Logger log = LoggerFactory.getLogger(TestDiagnosticController.class);
    @Autowired
    private TestService testService;

    @GetMapping(value={"/generer-test/{matiereId}"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<List<QuestionDiagnosticDto>> genererTest(@PathVariable Long matiereId) {
        log.info("Requ\u00eate pour g\u00e9n\u00e9rer un test de diagnostic pour la mati\u00e8re ID: {}", (Object)matiereId);
        List questions = this.testService.genererTestDiagnosticPourMatiere(matiereId);
        log.info("Envoi de {} questions pour le test de diagnostic.", (Object)questions.size());
        return ResponseEntity.ok((Object)questions);
    }

    @PostMapping(value={"/corriger-test"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<ResultatDiagnosticDto> corrigerTest(@RequestBody SoumissionTestDto soumission) {
        log.info("Requ\u00eate de correction re\u00e7ue avec {} r\u00e9ponses.", (Object)soumission.getReponses().size());
        ResultatDiagnosticDto resultat = this.testService.corrigerTestDiagnostic(soumission);
        return ResponseEntity.ok((Object)resultat);
    }
}

