/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.controller.TestController;
import com.moscepa.dto.HistoriqueResultatDto;
import com.moscepa.dto.QuestionDto;
import com.moscepa.dto.QuestionnaireDetailDto;
import com.moscepa.dto.ResultatTestDto;
import com.moscepa.entity.Test;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.QuestionnaireService;
import com.moscepa.service.TestService;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tests"})
public class TestController {
    private final TestService testService;
    private final QuestionnaireService questionnaireService;

    public TestController(TestService testService, QuestionnaireService questionnaireService) {
        this.testService = testService;
        this.questionnaireService = questionnaireService;
    }

    @GetMapping(value={"/chapitre/{chapitreId}/questions"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<QuestionDto>> getQuestions(@PathVariable Long chapitreId) {
        List questions = this.testService.getQuestionsPourChapitre(chapitreId);
        return ResponseEntity.ok((Object)questions);
    }

    @PostMapping(value={"/chapitre/{chapitreId}/soumettre"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<ResultatTestDto> soumettreTest(@PathVariable Long chapitreId, @RequestBody Map<String, Object> reponses, @AuthenticationPrincipal UserPrincipal userPrincipal) {
        ResultatTestDto resultat = this.testService.calculerEtSauvegarderResultat(chapitreId, userPrincipal.getId(), reponses);
        return ResponseEntity.ok((Object)resultat);
    }

    @GetMapping(value={"/mon-historique"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<HistoriqueResultatDto>> getMonHistorique(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        List historique = this.testService.getHistoriquePourEtudiant(utilisateurId);
        return ResponseEntity.ok((Object)historique);
    }

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Test> createTest(@RequestBody CreateTestRequest request) {
        Test nouveauTest = this.testService.creerTestAvecQuestions(request.chapitreId, request.titre, request.questionIds);
        return new ResponseEntity((Object)nouveauTest, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/chapitre/{chapitreId}/choix-questionnaires"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<List<QuestionnaireDetailDto>> getChoixQuestionnaires(@PathVariable Long chapitreId) {
        List choix = this.questionnaireService.getQuestionnairesParChapitre(chapitreId);
        return ResponseEntity.ok((Object)choix);
    }

    @PostMapping(value={"/chapitre/{chapitreId}/assigner/{questionnaireId}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Test> assignerTest(@PathVariable Long chapitreId, @PathVariable Long questionnaireId) {
        Test test = this.testService.assignerQuestionnaireAuTest(chapitreId, questionnaireId);
        return ResponseEntity.ok((Object)test);
    }

    @PostMapping(value={"/questionnaire/{questionnaireId}/entrainement"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<ResultatTestDto> verifierEntrainement(@PathVariable Long questionnaireId, @RequestBody Map<String, Object> reponses) {
        return ResponseEntity.ok((Object)this.testService.calculerResultatEntrainement(questionnaireId, reponses));
    }
}

