/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.StudentJourneyFrontDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.StudentJourneyService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/front/student-journey"})
@CrossOrigin(origins={"*"})
public class StudentJourneyFrontController {
    private final StudentJourneyService studentJourneyService;

    public StudentJourneyFrontController(StudentJourneyService studentJourneyService) {
        this.studentJourneyService = studentJourneyService;
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<StudentJourneyFrontDto> getParcoursEtudiantConnecteFront(@AuthenticationPrincipal UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            return ResponseEntity.status((int)401).build();
        }
        return ResponseEntity.ok((Object)this.studentJourneyService.getStudentJourneyForFrontend(userPrincipal.getId()));
    }

    @GetMapping(value={"/{studentId}"})
    @PreAuthorize(value="hasAnyRole('ADMIN', 'ENSEIGNANT')")
    public ResponseEntity<StudentJourneyFrontDto> getParcoursEtudiantFront(@PathVariable Long studentId) {
        return ResponseEntity.ok((Object)this.studentJourneyService.getStudentJourneyForFrontend(studentId));
    }

    @GetMapping(value={"/all"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<List<StudentJourneyFrontDto>> getAllParcoursFront(@RequestParam(required=false) String type) {
        return ResponseEntity.ok((Object)this.studentJourneyService.getAllJourneysForFrontend(type));
    }

    @GetMapping(value={"/teacher-students"})
    @PreAuthorize(value="hasAnyRole('ADMIN', 'TUTEUR', 'ENSEIGNANT')")
    public ResponseEntity<List<StudentJourneyFrontDto>> getMyStudents(@AuthenticationPrincipal UserPrincipal userPrincipal) {
        return ResponseEntity.ok((Object)this.studentJourneyService.getStudentsForTeacherForFrontend(userPrincipal.getId()));
    }
}

