/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.StudentJourneyDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.StudentJourneyService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/student-journey"})
@CrossOrigin(origins={"*"})
public class StudentJourneyController {
    private final StudentJourneyService studentJourneyService;

    public StudentJourneyController(StudentJourneyService studentJourneyService) {
        this.studentJourneyService = studentJourneyService;
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<StudentJourneyDto> getParcoursEtudiantConnecte(@AuthenticationPrincipal UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            return ResponseEntity.status((int)401).build();
        }
        Long utilisateurId = userPrincipal.getId();
        StudentJourneyDto parcours = this.studentJourneyService.getStudentJourney(utilisateurId);
        return ResponseEntity.ok((Object)parcours);
    }

    @GetMapping(value={"/{studentId}"})
    public ResponseEntity<StudentJourneyDto> getParcoursEtudiant(@PathVariable String studentId) {
        Long id;
        if ("all".equalsIgnoreCase(studentId)) {
            return ResponseEntity.badRequest().build();
        }
        try {
            id = Long.parseLong(studentId);
        }
        catch (NumberFormatException e) {
            return ResponseEntity.badRequest().build();
        }
        StudentJourneyDto parcours = this.studentJourneyService.getStudentJourney(id);
        return ResponseEntity.ok((Object)parcours);
    }

    @GetMapping(value={"/mes-etudiants"})
    @PreAuthorize(value="hasRole('ENSEIGNANT')")
    public ResponseEntity<List<StudentJourneyDto>> getStudentsForTeacher(@AuthenticationPrincipal UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            return ResponseEntity.status((int)401).build();
        }
        Long teacherId = userPrincipal.getId();
        List journeys = this.studentJourneyService.getStudentsForTeacher(teacherId);
        return ResponseEntity.ok((Object)journeys);
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<StudentJourneyDto>> getAllParcours(@RequestParam(required=false) String type) {
        List journeys = this.studentJourneyService.getAllJourneys(type);
        return ResponseEntity.ok((Object)journeys);
    }
}

