/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.entity.RessourcePedagogique;
import com.moscepa.service.RessourcePedagogiqueService;
import java.io.IOException;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/ressources"})
@CrossOrigin(origins={"http://localhost:4200"})
public class RessourcePedagogiqueController {
    private final RessourcePedagogiqueService ressourceService;

    public RessourcePedagogiqueController(RessourcePedagogiqueService ressourceService) {
        this.ressourceService = ressourceService;
    }

    @PostMapping(consumes={"multipart/form-data"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<RessourcePedagogique> televerserRessource(@RequestPart(value="fichier") MultipartFile fichier, @RequestPart(value="metadata") String metadataJson) {
        try {
            RessourcePedagogique ressource = this.ressourceService.televerserEtSauvegarder(fichier, metadataJson);
            return new ResponseEntity((Object)ressource, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<RessourcePedagogique>> getAllRessources() {
        List ressources = this.ressourceService.findAll();
        return ResponseEntity.ok((Object)ressources);
    }

    @GetMapping(value={"/telecharger/{nomFichierStocke}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Resource> telechargerRessource(@PathVariable String nomFichierStocke) {
        Resource file = this.ressourceService.chargerFichierCommeRessource(nomFichierStocke);
        RessourcePedagogique ressource = this.ressourceService.findAll().stream().filter(r -> r.getCheminStockage().equals(nomFichierStocke)).findFirst().orElse(null);
        String nomFichierOriginal = ressource != null ? ressource.getNomFichier() : nomFichierStocke;
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)ressource.getTypeMime())).header("Content-Disposition", new String[]{"attachment; filename=\"" + nomFichierOriginal + "\""})).body((Object)file);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Void> supprimerRessource(@PathVariable Long id) {
        this.ressourceService.supprimerRessource(id);
        return ResponseEntity.noContent().build();
    }
}

