/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.GenerationRequestDto;
import com.moscepa.dto.QuestionnaireDetailDto;
import com.moscepa.service.QuestionnaireService;
import jakarta.validation.Valid;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/questionnaires"})
@CrossOrigin(value={"*"})
public class QuestionnaireController {
    private static final Logger logger = LoggerFactory.getLogger(QuestionnaireController.class);
    @Autowired
    private QuestionnaireService questionnaireService;

    @GetMapping
    public ResponseEntity<List<QuestionnaireDetailDto>> getAllQuestionnaires() {
        logger.info("\ud83d\udce5 GET /api/questionnaires");
        List questionnaires = this.questionnaireService.getAllQuestionnairesDetail();
        logger.info("\ud83d\udce4 Retourne {} questionnaires", (Object)questionnaires.size());
        return ResponseEntity.ok((Object)questionnaires);
    }

    @GetMapping(value={"/exercices"})
    public ResponseEntity<List<QuestionnaireDetailDto>> getExercices() {
        logger.info("\ud83d\udce5 GET /api/questionnaires/exercices");
        List exercices = this.questionnaireService.getExercicesOnly();
        return ResponseEntity.ok((Object)exercices);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<QuestionnaireDetailDto> getQuestionnaireById(@PathVariable Long id) {
        logger.info("\ud83d\udce5 GET /api/questionnaires/{}", (Object)id);
        QuestionnaireDetailDto questionnaire = this.questionnaireService.getQuestionnaireDetailById(id);
        return ResponseEntity.ok((Object)questionnaire);
    }

    @PostMapping
    public ResponseEntity<?> createQuestionnaire(@RequestBody QuestionnaireDetailDto dto) {
        logger.info("\ud83d\udce5 POST /api/questionnaires");
        logger.info("Donn\u00e9es re\u00e7ues: titre={}, chapitreId={}", (Object)dto.getTitre(), (Object)dto.getChapitreId());
        try {
            QuestionnaireDetailDto created = this.questionnaireService.createQuestionnaire(dto);
            logger.info("\u2705 Questionnaire cr\u00e9\u00e9 avec ID: {}", (Object)created.getId());
            return ResponseEntity.ok((Object)created);
        }
        catch (IllegalArgumentException e) {
            logger.error("\u274c Erreur validation: {}", (Object)e.getMessage());
            return ResponseEntity.badRequest().body((Object)("Erreur: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u274c Erreur cr\u00e9ation questionnaire: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((int)500).body((Object)("Erreur serveur: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/generer-depuis-banque"})
    public ResponseEntity<?> genererQuestionnaireDepuisBanque(@Valid @RequestBody GenerationRequestDto generationRequest, BindingResult bindingResult) {
        logger.info("\ud83d\udce5 POST /api/questionnaires/generer-depuis-banque");
        if (bindingResult.hasErrors()) {
            logger.error("\u274c Validation \u00e9chou\u00e9e: {}", (Object)bindingResult.getAllErrors());
            return ResponseEntity.badRequest().body((Object)bindingResult.getAllErrors());
        }
        try {
            QuestionnaireDetailDto generated = this.questionnaireService.genererQuestionnaireDepuisBanque(generationRequest);
            logger.info("\u2705 Questionnaire g\u00e9n\u00e9r\u00e9 avec ID: {}", (Object)generated.getId());
            return ResponseEntity.ok((Object)generated);
        }
        catch (Exception e) {
            logger.error("\u274c Erreur g\u00e9n\u00e9ration questionnaire: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((int)500).body((Object)("Erreur serveur: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<QuestionnaireDetailDto> updateQuestionnaire(@PathVariable Long id, @RequestBody QuestionnaireDetailDto dto) {
        logger.info("\ud83d\udce5 PUT /api/questionnaires/{}", (Object)id);
        QuestionnaireDetailDto updated = this.questionnaireService.updateQuestionnaire(id, dto);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteQuestionnaire(@PathVariable Long id) {
        logger.info("\ud83d\udce5 DELETE /api/questionnaires/{}", (Object)id);
        boolean deleted = this.questionnaireService.deleteQuestionnaire(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

