/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.ChapitreProgressFrontDto;
import com.moscepa.dto.MatiereStatutDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.ProgressionService;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/front/progression"})
@CrossOrigin(origins={"*"})
public class ProgressionFrontController {
    private final ProgressionService progressionService;

    public ProgressionFrontController(ProgressionService progressionService) {
        this.progressionService = progressionService;
    }

    @GetMapping(value={"/mes-matieres"})
    public ResponseEntity<List<MatiereStatutDto>> getMatieresPourEtudiantConnecteFront(@AuthenticationPrincipal UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            return ResponseEntity.status((int)401).build();
        }
        Long utilisateurId = userPrincipal.getId();
        List matieres = this.progressionService.findMatieresByEtudiant(utilisateurId);
        return ResponseEntity.ok((Object)matieres);
    }

    @GetMapping(value={"/etudiant/{studentId}/chapitres"})
    public ResponseEntity<List<ChapitreProgressFrontDto>> getChapitresProgressForStudentFront(@PathVariable Long studentId, @RequestParam(required=false) String parcoursType) {
        try {
            List chapitres = this.progressionService.findChapitresProgressForFrontend(studentId, parcoursType);
            if (chapitres.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.ok((Object)chapitres);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).build();
        }
    }

    @GetMapping(value={"/etudiant/{studentId}/chapitres-groupes"})
    public ResponseEntity<Map<String, List<ChapitreProgressFrontDto>>> getChapitresGroupedByMatiereFront(@PathVariable Long studentId, @RequestParam(required=false) String parcoursType) {
        try {
            Map chapitresGroupes = this.progressionService.findChapitresGroupedForFrontend(studentId, parcoursType);
            if (chapitresGroupes.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.ok((Object)chapitresGroupes);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).build();
        }
    }

    @GetMapping(value={"/mes-chapitres"})
    public ResponseEntity<List<ChapitreProgressFrontDto>> getMesChapitresProgressFront(@AuthenticationPrincipal UserPrincipal userPrincipal, @RequestParam(required=false) String parcoursType) {
        if (userPrincipal == null) {
            return ResponseEntity.status((int)401).build();
        }
        Long utilisateurId = userPrincipal.getId();
        List chapitres = this.progressionService.findChapitresProgressForFrontend(utilisateurId, parcoursType);
        return ResponseEntity.ok((Object)chapitres);
    }
}

