/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.service.PermissionService;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/permissions"})
@CrossOrigin(origins={"http://localhost:4200"})
public class PermissionController {
    @Autowired
    private PermissionService permissionService;

    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<Map<String, Set<String>>> getAllPermissions() {
        return ResponseEntity.ok((Object)this.permissionService.getAllPermissionsByRole());
    }

    @PutMapping(value={"/{roleName}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<Void> updatePermissions(@PathVariable String roleName, @RequestBody Set<String> allowedFeatures) {
        this.permissionService.updatePermissionsForRole(roleName.toUpperCase(), allowedFeatures);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<Set<String>> getMyPermissions() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || "anonymousUser".equals(authentication.getPrincipal())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        String userRole = authentication.getAuthorities().stream().findFirst().map(grantedAuthority -> grantedAuthority.getAuthority().replace("ROLE_", "")).orElse(null);
        if (userRole == null) {
            return ResponseEntity.ok(Set.of());
        }
        Map allPermissions = this.permissionService.getAllPermissionsByRole();
        Set myPermissions = allPermissions.getOrDefault(userRole, Set.of());
        return ResponseEntity.ok(myPermissions);
    }
}

