/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.ParcoursDto;
import com.moscepa.dto.ParcoursRequestDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.ParcoursService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parcours"})
@CrossOrigin(origins={"http://localhost:4200"})
public class ParcoursController {
    private final ParcoursService parcoursService;

    public ParcoursController(ParcoursService parcoursService) {
        this.parcoursService = parcoursService;
    }

    @GetMapping(value={"/etudiant/me"})
    public ResponseEntity<ParcoursDto> getMesParcours(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        ParcoursDto parcours = this.parcoursService.getParcoursPourEtudiant(utilisateurId);
        return ResponseEntity.ok((Object)parcours);
    }

    @GetMapping(value={"/etudiant/{etudiantId}"})
    public ResponseEntity<ParcoursDto> getParcoursPourEtudiant(@PathVariable Long etudiantId) {
        ParcoursDto parcours = this.parcoursService.getParcoursPourEtudiant(etudiantId);
        return ResponseEntity.ok((Object)parcours);
    }

    @PostMapping(value={"/etudiant"})
    public ResponseEntity<Void> enregistrerParcours(Authentication authentication, @RequestBody ParcoursRequestDto request) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        List chapitreIds = request.getChapitresChoisisIds();
        this.parcoursService.enregistrerChoixEtudiant(utilisateurId, chapitreIds);
        return ResponseEntity.ok().build();
    }
}

