/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.ChapitreContenuDto;
import com.moscepa.dto.ChapitreCreateDto;
import com.moscepa.service.ChapitreService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/matieres/{matiereId}"})
public class MatiereContenuController {
    @Autowired
    private ChapitreService chapitreService;

    @GetMapping(value={"/contenu"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN', 'RESPONSABLE_FORMATION','ETUDIANT')")
    public ResponseEntity<List<ChapitreContenuDto>> getContenuCompletPourMatiere(@PathVariable Long matiereId) {
        List contenu = this.chapitreService.findContenuCompletPourMatiere(matiereId);
        return ResponseEntity.ok((Object)contenu);
    }

    @PostMapping(value={"/chapitres"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN', 'RESPONSABLE_FORMATION')")
    public ResponseEntity<ChapitreContenuDto> createChapitre(@PathVariable Long matiereId, @Valid @RequestBody ChapitreCreateDto dto) {
        ChapitreContenuDto nouveauChapitre = this.chapitreService.createChapitre(matiereId, dto);
        return new ResponseEntity((Object)nouveauChapitre, (HttpStatusCode)HttpStatus.CREATED);
    }
}

