/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.InscriptionRequestDto;
import com.moscepa.dto.InscriptionResponseDto;
import com.moscepa.dto.InscriptionValidationRequest;
import com.moscepa.entity.Utilisateur;
import com.moscepa.service.InscriptionService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/inscriptions"})
public class InscriptionController {
    private final InscriptionService inscriptionService;

    public InscriptionController(InscriptionService inscriptionService) {
        this.inscriptionService = inscriptionService;
    }

    @GetMapping(value={"/mes-matieres"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<List<InscriptionResponseDto>> getMesMatieres(@AuthenticationPrincipal Utilisateur utilisateurConnecte) {
        List data = this.inscriptionService.getMesInscriptionsValidees(utilisateurConnecte.getId());
        return ResponseEntity.ok((Object)data);
    }

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ADMIN', 'RESPONSABLE_FORMATION')")
    public ResponseEntity<InscriptionResponseDto> inscrire(@RequestBody InscriptionRequestDto request) {
        return new ResponseEntity((Object)this.inscriptionService.inscrireEtudiant(request), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/valider"})
    @PreAuthorize(value="hasAnyRole('ADMIN', 'RESPONSABLE_FORMATION')")
    public ResponseEntity<InscriptionResponseDto> valider(@RequestBody InscriptionValidationRequest req) {
        return ResponseEntity.ok((Object)this.inscriptionService.validerInscription(req));
    }

    @GetMapping(value={"/en-attente"})
    @PreAuthorize(value="hasAnyRole('ADMIN', 'RESPONSABLE_FORMATION')")
    public ResponseEntity<List<InscriptionResponseDto>> getEnAttente() {
        return ResponseEntity.ok((Object)this.inscriptionService.getInscriptionsEnAttente());
    }
}

