/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.FormationCreationDto;
import com.moscepa.dto.FormationDetailDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.FormationService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/formations"})
@CrossOrigin(origins={"http://localhost:4200"})
public class FormationController {
    private final FormationService formationService;

    public FormationController(FormationService formationService) {
        this.formationService = formationService;
    }

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<FormationDetailDto> creerFormation(@Valid @RequestBody FormationCreationDto dto) {
        FormationDetailDto nouvelleFormation = this.formationService.creerFormation(dto);
        return new ResponseEntity((Object)nouvelleFormation, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/mes-formations"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<List<FormationDetailDto>> getMesFormations(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long createurId = userPrincipal.getId();
        List formations = this.formationService.getFormationsByCreateurId(createurId);
        return ResponseEntity.ok((Object)formations);
    }

    @GetMapping
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<FormationDetailDto>> getAllFormations() {
        List formations = this.formationService.getAllFormations();
        return ResponseEntity.ok((Object)formations);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<FormationDetailDto> getFormationById(@PathVariable Long id) {
        FormationDetailDto formation = this.formationService.getFormationById(id);
        return ResponseEntity.ok((Object)formation);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Void> supprimerFormation(@PathVariable Long id) {
        this.formationService.supprimerFormation(id);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<FormationDetailDto> modifierFormation(@PathVariable Long id, @Valid @RequestBody FormationCreationDto dto) {
        FormationDetailDto formationModifiee = this.formationService.modifierFormation(id, dto);
        return ResponseEntity.ok((Object)formationModifiee);
    }
}

