/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.EtudiantRegistrationDto;
import com.moscepa.service.EtudiantService;
import jakarta.validation.Valid;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/etudiants"})
public class EtudiantController {
    @Autowired
    private EtudiantService etudiantService;

    @PostMapping(value={"/inscrire"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<String> inscrireNouvelEtudiant(@Valid @RequestBody EtudiantRegistrationDto etudiantDto) {
        this.etudiantService.inscrireEtudiant(etudiantDto);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "\u00c9tudiant inscrit avec succ\u00e8s.");
        return new ResponseEntity((Object)"\u00c9tudiant inscrit avec succ\u00e8s.", (HttpStatusCode)HttpStatus.CREATED);
    }
}

