/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.EchelleConnaissanceDto;
import com.moscepa.service.EchelleConnaissanceService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/echelles-connaissance"})
@CrossOrigin(origins={"http://localhost:4200"})
public class EchelleConnaissanceController {
    private final EchelleConnaissanceService service;

    public EchelleConnaissanceController(EchelleConnaissanceService service) {
        this.service = service;
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('ADMIN', 'ENSEIGNANT')")
    public ResponseEntity<List<EchelleConnaissanceDto>> getAll() {
        return ResponseEntity.ok((Object)this.service.findAll());
    }

    @PostMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<EchelleConnaissanceDto> create(@Valid @RequestBody EchelleConnaissanceDto dto) {
        EchelleConnaissanceDto newEchelle = this.service.create(dto);
        return new ResponseEntity((Object)newEchelle, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<EchelleConnaissanceDto> update(@PathVariable Long id, @Valid @RequestBody EchelleConnaissanceDto dto) {
        EchelleConnaissanceDto updatedEchelle = this.service.update(id, dto);
        return ResponseEntity.ok((Object)updatedEchelle);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        this.service.delete(id);
        return ResponseEntity.noContent().build();
    }
}

