/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.CategorieDto;
import com.moscepa.service.CategorieService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/categories"})
public class CategorieController {
    private final CategorieService categorieService;

    public CategorieController(CategorieService categorieService) {
        this.categorieService = categorieService;
    }

    @GetMapping
    public ResponseEntity<List<CategorieDto>> getAll() {
        return ResponseEntity.ok((Object)this.categorieService.findAll());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CategorieDto> getById(@PathVariable Long id) {
        CategorieDto dto = this.categorieService.findById(id);
        if (dto == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping
    public ResponseEntity<CategorieDto> create(@RequestBody CategorieDto dto) {
        return ResponseEntity.ok((Object)this.categorieService.create(dto));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CategorieDto> update(@PathVariable Long id, @RequestBody CategorieDto dto) {
        return ResponseEntity.ok((Object)this.categorieService.update(id, dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        this.categorieService.delete(id);
        return ResponseEntity.noContent().build();
    }
}

