/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.UserRegistrationDto;
import com.moscepa.dto.UserResponseDto;
import com.moscepa.entity.Role;
import com.moscepa.service.UserManagementService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
@CrossOrigin(origins={"*"})
@Tag(name="Administration", description="API d'administration des utilisateurs (r\u00e9serv\u00e9e aux administrateurs)")
@SecurityRequirement(name="bearerAuth")
public class AdminController {
    @Autowired
    private UserManagementService userManagementService;

    @PostMapping(value={"/users"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Cr\u00e9er un utilisateur", description="Cr\u00e9e un nouvel utilisateur (r\u00e9serv\u00e9 aux administrateurs)")
    public ResponseEntity<?> createUser(@Valid @RequestBody UserRegistrationDto userRegistrationDto) {
        try {
            UserResponseDto createdUser = this.userManagementService.createUser(userRegistrationDto);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Utilisateur cr\u00e9\u00e9 avec succ\u00e8s");
            response.put("user", (String)createdUser);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", e.getMessage());
            error.put("error", "USER_CREATION_FAILED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @GetMapping(value={"/users"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Lister tous les utilisateurs", description="R\u00e9cup\u00e8re la liste de tous les utilisateurs")
    public ResponseEntity<List<UserResponseDto>> getAllUsers() {
        List users = this.userManagementService.getAllUsers();
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/users/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="R\u00e9cup\u00e9rer un utilisateur", description="R\u00e9cup\u00e8re un utilisateur par son ID")
    public ResponseEntity<?> getUserById(@PathVariable Long id) {
        return this.userManagementService.getUserById(id).map(user -> ResponseEntity.ok((Object)user)).orElse(ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/users/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Mettre \u00e0 jour un utilisateur", description="Met \u00e0 jour les informations d'un utilisateur")
    public ResponseEntity<?> updateUser(@PathVariable Long id, @Valid @RequestBody UserRegistrationDto userRegistrationDto) {
        try {
            UserResponseDto updatedUser = this.userManagementService.updateUser(id, userRegistrationDto);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Utilisateur mis \u00e0 jour avec succ\u00e8s");
            response.put("user", (String)updatedUser);
            return ResponseEntity.ok(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", e.getMessage());
            error.put("error", "USER_UPDATE_FAILED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @PatchMapping(value={"/users/{id}/deactivate"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="D\u00e9sactiver un utilisateur", description="D\u00e9sactive un utilisateur")
    public ResponseEntity<?> deactivateUser(@PathVariable Long id) {
        try {
            this.userManagementService.deactivateUser(id);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Utilisateur d\u00e9sactiv\u00e9 avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", e.getMessage());
            error.put("error", "USER_DEACTIVATION_FAILED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @PatchMapping(value={"/users/{id}/activate"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Activer un utilisateur", description="Active un utilisateur")
    public ResponseEntity<?> activateUser(@PathVariable Long id) {
        try {
            this.userManagementService.activateUser(id);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Utilisateur activ\u00e9 avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", e.getMessage());
            error.put("error", "USER_ACTIVATION_FAILED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @DeleteMapping(value={"/users/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Supprimer un utilisateur", description="Supprime d\u00e9finitivement un utilisateur")
    public ResponseEntity<?> deleteUser(@PathVariable Long id) {
        try {
            this.userManagementService.deleteUser(id);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Utilisateur supprim\u00e9 avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", e.getMessage());
            error.put("error", "USER_DELETION_FAILED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @GetMapping(value={"/users/role/{role}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Lister les utilisateurs par r\u00f4le", description="R\u00e9cup\u00e8re tous les utilisateurs d'un r\u00f4le sp\u00e9cifique")
    public ResponseEntity<List<UserResponseDto>> getUsersByRole(@PathVariable Role role) {
        List users = this.userManagementService.getUsersByRole(role);
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/users/search"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Rechercher des utilisateurs", description="Recherche des utilisateurs par nom ou pr\u00e9nom")
    public ResponseEntity<List<UserResponseDto>> searchUsers(@RequestParam String q) {
        List users = this.userManagementService.searchUsers(q);
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/users/stats"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Statistiques des utilisateurs", description="R\u00e9cup\u00e8re les statistiques des utilisateurs par r\u00f4le")
    public ResponseEntity<Map<String, Object>> getUserStats() {
        HashMap<String, Number> stats = new HashMap<String, Number>();
        for (Role role : Role.values()) {
            stats.put(role.name().toLowerCase(), this.userManagementService.countUsersByRole(role));
        }
        stats.put("total", this.userManagementService.getAllUsers().size());
        return ResponseEntity.ok(stats);
    }

    @GetMapping(value={"/users/check-email"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="V\u00e9rifier l'existence d'un email", description="V\u00e9rifie si un email est d\u00e9j\u00e0 utilis\u00e9")
    public ResponseEntity<Map<String, Boolean>> checkEmailExists(@RequestParam String email) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("exists", this.userManagementService.emailExists(email));
        return ResponseEntity.ok(response);
    }
}

