/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.config;

import com.moscepa.entity.Fonctionnalite;
import com.moscepa.entity.Role;
import com.moscepa.entity.RolePermission;
import com.moscepa.entity.SousFonctionnalite;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.FonctionnaliteRepository;
import com.moscepa.repository.RolePermissionRepository;
import com.moscepa.repository.UtilisateurRepository;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.DependsOn;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@DependsOn(value={"entityManagerFactory"})
public class DataInitializer
implements CommandLineRunner {
    @Autowired
    private UtilisateurRepository utilisateurRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private FonctionnaliteRepository fonctionnaliteRepository;
    @Autowired
    private RolePermissionRepository permissionRepository;

    @Transactional
    public void run(String ... args) throws Exception {
        if (!this.utilisateurRepository.existsByEmail("admin@moscepa.com")) {
            Utilisateur admin = new Utilisateur();
            admin.setNom("Admin");
            admin.setPrenom("Super");
            admin.setEmail("admin@moscepa.com");
            admin.setMotDePasse(this.passwordEncoder.encode((CharSequence)"admin123"));
            admin.setRole(Role.ADMIN);
            admin.setActif(Boolean.valueOf(true));
            this.utilisateurRepository.save((Object)admin);
            System.out.println("\u2705 Admin par d\u00e9faut cr\u00e9\u00e9 : admin@moscepa.com / admin123");
        } else {
            System.out.println("\u2139\ufe0f Admin par d\u00e9faut d\u00e9j\u00e0 pr\u00e9sent dans la base.");
        }
        if (this.fonctionnaliteRepository.count() == 0L) {
            System.out.println("\u23f3 Initialisation des fonctionnalit\u00e9s par d\u00e9faut...");
            List<Fonctionnalite> defaultFeatures = Arrays.asList(this.createFonctionnalite("Param\u00e9trage", "parametrage", "settings", new SousFonctionnalite[]{this.createSousFonctionnalite("Profil utilisateur", "profil_utilisateur", "/app/profil"), this.createSousFonctionnalite("Modifier mot de passe", "modifier_mot_passe", "/app/profil/change-password"), this.createSousFonctionnalite("Modifier profil", "modifier_profil", "/app/profil/edit")}), this.createFonctionnalite("Gestion des utilisateurs", "gestion_utilisateurs", "users", new SousFonctionnalite[]{this.createSousFonctionnalite("Gestion Des r\u00f4les", "gestion_roles", "/app/admin/roles"), this.createSousFonctionnalite("Permissions", "gestion_permissions", "/app/admin/permissions"), this.createSousFonctionnalite("Gestion utilisateur", "gestion_utilisateur", "/app/admin/users")}), this.createFonctionnalite("Gestion des fonctionnalit\u00e9s", "gestion_fonctionnalites", "settings", new SousFonctionnalite[]{this.createSousFonctionnalite("Ajouter fonctionnalit\u00e9", "ajouter_fonctionnalite", "/app/admin/features"), this.createSousFonctionnalite("Attribuer une fonctionnalit\u00e9", "attribuer_fonctionnalite", "/app/admin/feature-assignment"), this.createSousFonctionnalite("Liste des fonctionnalit\u00e9s", "liste_fonctionnalites", "/app/admin/permssionsManegement"), this.createSousFonctionnalite("Gestion des Permissions", "gestion_permissions_admin", "/app/admin/permissions")}), this.createFonctionnalite("Gestion des formations", "gestion_formations", "book", new SousFonctionnalite[]{this.createSousFonctionnalite("Etablissement", "etablissement", "/app/enseignant/etablissements"), this.createSousFonctionnalite("UFR", "uefr", "/app/enseignant/uefr"), this.createSousFonctionnalite("D\u00e9partement", "departement", "/app/enseignant/departements"), this.createSousFonctionnalite("Offre de formations", "liste_formations", "/app/enseignant/formations"), this.createSousFonctionnalite("Liste formation", "gerer_inscriptions", "/app/enseignant/listeformation")}), this.createFonctionnalite("Gestion des maquettes", "gestion_maquettes", "layout", new SousFonctionnalite[]{this.createSousFonctionnalite("Unit\u00e9 d'enseignement", "gestion_unites", "/app/admin/unites-enseignement"), this.createSousFonctionnalite("\u00c9l\u00e9ments constitutifs", "gestion_elements", "/app/admin/elements-constitutifs"), this.createSousFonctionnalite("Param\u00e9trage des chapitres", "parametrage_chapitres", "/app/admin/parametrage-chapitre"), this.createSousFonctionnalite("Structure des mati\u00e8res", "structure_matieres", "/app/admin/matieres"), this.createSousFonctionnalite("Syllabus", "syllabus", "/app/admin/chapitres")}), this.createFonctionnalite("Gestion des inscriptions aux classes", "gestion_inscriptions_classes", "user-plus", new SousFonctionnalite[]{this.createSousFonctionnalite("Inscriptions aux classes", "inscriptions_classes", "/app/admin/inscriptions"), this.createSousFonctionnalite("Validation inscriptions", "validation_inscriptions", "/app/admin/validation-inscriptions")}), this.createFonctionnalite("Gestion des \u00e9quivalences", "gestion_equivalences", "equal", new SousFonctionnalite[]{this.createSousFonctionnalite("Cr\u00e9er \u00e9quivalence", "creer_equivalence", "/app/admin/equivalences/create"), this.createSousFonctionnalite("Liste \u00e9quivalences", "liste_equivalences", "/app/admin/equivalences")}), this.createFonctionnalite("Gestion des parcours (Admin)", "gestion_parcours_admin", "route", new SousFonctionnalite[]{this.createSousFonctionnalite("Parcours recommand\u00e9s", "parcours_recommandes_admin", "/app/admin/parcours"), this.createSousFonctionnalite("Parcours choisis", "parcours_choisis_admin", "/app/admin/parcours"), this.createSousFonctionnalite("Parcours mixtes", "parcours_mixtes_admin", "/app/admin/parcours")}), this.createFonctionnalite("Gestion des ressources p\u00e9dagogiques", "gestion_ressources_pedagogiques", "folder", new SousFonctionnalite[]{this.createSousFonctionnalite("G\u00e9rer mes ressources", "gerer_mes_ressources", "/app/enseignant/gestion-contenu"), this.createSousFonctionnalite("Mes ressources", "mes_ressources", "/app/enseignant/ressources"), this.createSousFonctionnalite("Biblioth\u00e8que", "bibliotheque", "/app/enseignant/banques")}), this.createFonctionnalite("Gestion des \u00e9chelles de connaissances", "gestion_echelles_connaissances", "bar-chart", new SousFonctionnalite[]{this.createSousFonctionnalite("\u00c9chelles de connaissances", "echelles_connaissances", "/app/admin/echelles"), this.createSousFonctionnalite("\u00c9valuation comp\u00e9tences", "evaluation_competences", "/app/admin/evaluation-competences")}), this.createFonctionnalite("Gestion des cat\u00e9gories", "gestion_categories", "tag", new SousFonctionnalite[]{this.createSousFonctionnalite("Cat\u00e9gories", "categories", "/app/admin/categories"), this.createSousFonctionnalite("Sous-cat\u00e9gories", "sous_categories", "/app/admin/sous-categories")}), this.createFonctionnalite("Gestion des questionnaires", "gestion_questionnaires", "help-circle", new SousFonctionnalite[]{this.createSousFonctionnalite("Cr\u00e9er Questionnaires", "liste_questionnaire", "/app/enseignant/gestion-questionnaire"), this.createSousFonctionnalite("liste Questionnaire", "creer_questionnaire", "/app/enseignant/listequestionnaire"), this.createSousFonctionnalite("Banque de questions", "banque_questions", "/app/enseignant/banque-questions")}), this.createFonctionnalite("Ressources externes", "gestion_ressources_externes", "external-link", new SousFonctionnalite[]{this.createSousFonctionnalite("Ressources externes", "external_resources_list", "/app/admin/external-resources"), this.createSousFonctionnalite("Banque de ressources", "external_resources_bank", "/app/admin/external-resources/bank")}), this.createFonctionnalite("Gestion des rem\u00e9diation", "gestion_remediation", "refresh-cw", new SousFonctionnalite[]{this.createSousFonctionnalite("Mati\u00e8res", "matieres", "/app/curriculum/matieres"), this.createSousFonctionnalite("Test de connaissance", "test_connaissance", "/app/student/test-connaissance"), this.createSousFonctionnalite("R\u00e9sultats", "resultats", "/app/student/mes-resultats")}), this.createFonctionnalite("Apprentissage asynchrone", "apprentissage_asynchrone", "play-circle", new SousFonctionnalite[]{this.createSousFonctionnalite("S\u00e9quences", "sequences", "/app/curriculum/sequences"), this.createSousFonctionnalite("Activit\u00e9s", "activites", "/app/curriculum/activites"), this.createSousFonctionnalite("\u00c9valuations", "evaluations", "/app/curriculum/evaluations")}), this.createFonctionnalite("Tutorat", "tutorat", "user-check", new SousFonctionnalite[]{this.createSousFonctionnalite("Mes \u00e9tudiants", "mes_etudiants", "/app/tuteur/listeetudiant"), this.createSousFonctionnalite("Suivi progression", "suivi_progression", "/app/tuteur/student"), this.createSousFonctionnalite("Planifier s\u00e9ances", "planifier_seances", "/app/tuteur/tests")}), this.createFonctionnalite("Enseignement", "enseignement", "graduation-cap", new SousFonctionnalite[]{this.createSousFonctionnalite("Mes cours", "mes_cours", "/app/enseignant/MesCours"), this.createSousFonctionnalite("Cr\u00e9er contenu", "creer_contenu", "/app/enseignant/formations"), this.createSousFonctionnalite("\u00c9valuer \u00e9tudiants", "evaluer_etudiants", "/app/enseignant/EvaluerEtudiant")}), this.createFonctionnalite("Mes parcours (\u00c9tudiant)", "mes_parcours_etudiant", "route", new SousFonctionnalite[]{this.createSousFonctionnalite("Parcours recommand\u00e9s", "parcours_recommandes_etudiant", "/app/student/parcours"), this.createSousFonctionnalite("Parcours choisis", "parcours_choisis_etudiant", "/app/student/parcours"), this.createSousFonctionnalite("Parcours mixtes", "parcours_mixtes_etudiant", "/app/student/parcours")}), this.createFonctionnalite("Innovation p\u00e9dagogique", "innovation_pedagogique", "lightbulb", new SousFonctionnalite[]{this.createSousFonctionnalite("Outils num\u00e9riques", "outils_numeriques", "/app/technopedagogue/outils-numeriques"), this.createSousFonctionnalite("M\u00e9thodes innovantes", "methodes_innovantes", "/app/technopedagogue/methodes-innovantes"), this.createSousFonctionnalite("Formation enseignants", "formation_enseignants", "/app/technopedagogue/formation-enseignants")}));
            this.fonctionnaliteRepository.saveAll(defaultFeatures);
            System.out.println("\u2705 " + defaultFeatures.size() + " fonctionnalit\u00e9s par d\u00e9faut ont \u00e9t\u00e9 cr\u00e9\u00e9es.");
        } else {
            System.out.println("\u2139\ufe0f Les fonctionnalit\u00e9s par d\u00e9faut sont d\u00e9j\u00e0 pr\u00e9sentes.");
        }
        if (this.permissionRepository.count() == 0L) {
            System.out.println("\u23f3 Initialisation des permissions par d\u00e9faut...");
            Set allKeys = this.fonctionnaliteRepository.findAll().stream().flatMap(f -> {
                Set keys = f.getSousFonctionnalites().stream().map(SousFonctionnalite::getFeatureKey).collect(Collectors.toSet());
                keys.add(f.getFeatureKey());
                return keys.stream();
            }).collect(Collectors.toSet());
            this.permissionRepository.save((Object)this.createRolePermission("ADMIN", allKeys));
            this.permissionRepository.save((Object)this.createRolePermission("ETUDIANT", Set.of("parametrage", "mes_parcours_etudiant", "gestion_remediation", "apprentissage_asynchrone")));
            this.permissionRepository.save((Object)this.createRolePermission("ENSEIGNANT", Set.of("parametrage", "enseignement", "gestion_ressources_pedagogiques", "gestion_echelles_connaissances", "gestion_questionnaires", "gestion_remediation", "apprentissage_asynchrone")));
            this.permissionRepository.save((Object)this.createRolePermission("TUTEUR", Set.of("parametrage", "tutorat", "gestion_remediation")));
            this.permissionRepository.save((Object)this.createRolePermission("TECHNOPEDAGOGUE", Set.of("parametrage", "innovation_pedagogique", "gestion_ressources_pedagogiques", "gestion_questionnaires", "apprentissage_asynchrone")));
            this.permissionRepository.save((Object)this.createRolePermission("RESPONSABLE_FORMATION", Set.of("parametrage", "gestion_formations", "gestion_maquettes", "gestion_inscriptions_classes", "gestion_equivalences", "gestion_parcours_admin")));
            System.out.println("\u2705 Permissions par d\u00e9faut cr\u00e9\u00e9es pour les r\u00f4les de base.");
        } else {
            System.out.println("\u2139\ufe0f Les permissions par d\u00e9faut sont d\u00e9j\u00e0 pr\u00e9sentes.");
        }
    }

    private Fonctionnalite createFonctionnalite(String nom, String key, String icon, SousFonctionnalite ... sous) {
        Fonctionnalite f = new Fonctionnalite();
        f.setNom(nom);
        f.setFeatureKey(key);
        f.setIcon(icon);
        f.setSousFonctionnalites(Arrays.asList(sous));
        return f;
    }

    private SousFonctionnalite createSousFonctionnalite(String label, String key, String route) {
        SousFonctionnalite sf = new SousFonctionnalite();
        sf.setLabel(label);
        sf.setFeatureKey(key);
        sf.setRoute(route);
        return sf;
    }

    private RolePermission createRolePermission(String roleName, Set<String> keys) {
        RolePermission rp = new RolePermission();
        rp.setRoleName(roleName);
        rp.setAllowedFeatures(keys);
        return rp;
    }
}

